/**************************************************************************/
/*                                                                        */
/* Module:             INTS_XXX.C                                         */
/*                                                                        */
/* Function:           Interactive Service Interface                      */
/*                     1. GetStruct                                       */
/*                     2. ShowStruct                                      */
/*                                                                        */
/* Author:             W. Reichert, D.3274                                */
/*                                                                        */
/* Date created:       1991-12-25                                         */
/*                                                                        */
/* Classification:     IBM Internal Use Only                              */
/*                                                                        */
/**************************************************************************/

/**************************************************************************/
/* Include files                                                          */
/**************************************************************************/

#define  INCL_WIN
#include <OS2.H>

#include <string.h>

#include "INTSRV.H"
#include "INTS_XXX.H"

/**************************************************************************/
/**************************************************************************/

/****** GetStruct() *******************************************************/
/*                                                                        */
/* Routine works like GetValue() but the value is a structure.            */
/* It asks for input for all elements of the specified structure.         */
/*                                                                        */
/* The following standard OS2 structures are supported:                   */
/*     POINTL                                                             */
/*     SIZEL                                                              */
/*     RECTL                                                              */
/*                                                                        */
/**************************************************************************/

USHORT GetStruct_(
    INT       iType,           /* i:   Type of structure                  */
    PSZ       pszName,         /* i:   Name of the input variable         */
    PVOID     pValue)          /* i/o: Pointer to current value           */
                               /* RC:  0 = OK  |  1 = Error               */
{
    CHAR    achText[90];
    size_t  iNameLen;

    PPOINTL pPointl  = (PPOINTL) pValue;
    PSIZEL  pSizel   = (PSIZEL)  pValue;
    PRECTL  pRectl   = (PRECTL)  pValue;

    strncpy(achText, pszName, 80);     /* The name of the element is      */
    iNameLen = strlen(achText);        /*   appended to the specified     */
                                       /*   variable name                 */
    switch (iType) {

      case TYPE_POINTL:
        strcpy(&achText[iNameLen], ".x");
        GetValue(TYPE_LONG, achText, &pPointl->x, 0, 0);
        strcpy(&achText[iNameLen], ".y");
        GetValue(TYPE_LONG, achText, &pPointl->y, 0, 0);
        break;

      case TYPE_SIZEL:
        strcpy(&achText[iNameLen], ".cx");
        GetValue(TYPE_LONG, achText, &pSizel->cx, 0, 0);
        strcpy(&achText[iNameLen], ".cy");
        GetValue(TYPE_LONG, achText, &pSizel->cy, 0, 0);
        break;

      case TYPE_RECTL:
        strcpy(&achText[iNameLen], ".xLeft");
        GetValue(TYPE_LONG, achText, &pRectl->xLeft,   0, 0);
        strcpy(&achText[iNameLen], ".yBottom");
        GetValue(TYPE_LONG, achText, &pRectl->yBottom, 0, 0);
        strcpy(&achText[iNameLen], ".xRight");
        GetValue(TYPE_LONG, achText, &pRectl->xRight,  0, 0);
        strcpy(&achText[iNameLen], ".yTop");
        GetValue(TYPE_LONG, achText, &pRectl->yTop,    0, 0);
        break;
    }

    return 0;
}

/****** ShowStruct() ******************************************************/
/*                                                                        */
/* Routine works like ShowValue() but the value is a structure.           */
/* It shows all elements of the specified structure.                      */
/*                                                                        */
/* The following standard OS2 structures are supported:                   */
/*     POINTL                                                             */
/*     SIZEL                                                              */
/*     RECTL                                                              */
/*                                                                        */
/**************************************************************************/

USHORT ShowStruct_(
    INT       iType,           /* i:   Type of structure                  */
    PSZ       pszName,         /* i:   Name of the input variable         */
    PVOID     pValue)          /* i:   Pointer to current value           */
{
    CHAR    achText[90];
    size_t  iNameLen;

    PPOINTL pPointl  = (PPOINTL) pValue;
    PSIZEL  pSizel   = (PSIZEL)  pValue;
    PRECTL  pRectl   = (PRECTL)  pValue;

    strncpy(achText, pszName, 80);     /* The name of the element is      */
    iNameLen = strlen(achText);        /*   appended to the specified     */
                                       /*   variable name                 */
    switch (iType) {

      case TYPE_POINTL:
        strcpy(&achText[iNameLen], ".x");
        ShowValue(TYPE_LONG, achText, &pPointl->x, 0L, 0);
        strcpy(&achText[iNameLen], ".y");
        ShowValue(TYPE_LONG, achText, &pPointl->y, 0L, 0);
        break;

      case TYPE_SIZEL:
        strcpy(&achText[iNameLen], ".cx");
        ShowValue(TYPE_LONG, achText, &pSizel->cx, 0L, 0);
        strcpy(&achText[iNameLen], ".cy");
        ShowValue(TYPE_LONG, achText, &pSizel->cy, 0L, 0);
        break;

      case TYPE_RECTL:
        strcpy(&achText[iNameLen], ".xLeft");
        ShowValue(TYPE_LONG, achText, &pRectl->xLeft,   0L, 0);
        strcpy(&achText[iNameLen], ".yBottom");
        ShowValue(TYPE_LONG, achText, &pRectl->yBottom, 0L, 0);
        strcpy(&achText[iNameLen], ".xRight");
        ShowValue(TYPE_LONG, achText, &pRectl->xRight,  0L, 0);
        strcpy(&achText[iNameLen], ".yTop");
        ShowValue(TYPE_LONG, achText, &pRectl->yTop,    0L, 0);
        break;
    }

    return 0;
}
